package it.softecspa.s4fs.vfat;

import it.softecspa.database.dbconnect.ConnectionManager;


/**
 * Gestore della Virtual File Allocation Table per i file cancellati
 * La struttura  identica alla VFAT eccetto che per la chiave e l'indice univoco
 * 
 * @author m.veroni
 * 
 */
public class GarbageAllocationTable extends VirtualAllocationTable {
	
	static final String NAME = "s4_011_vfat_garbage";
	
	
	public GarbageAllocationTable(ConnectionManager cm) {
		super(cm);
	}
	

	@Override
	String createSQL() {
		StringBuilder sql = new StringBuilder(200);
		sql.append("CREATE TABLE ").append(NAME).append(" (");
		sql.append(" uid int(10) UNSIGNED NOT NULL,");
		sql.append(" owner int(10) UNSIGNED NOT NULL,");
		sql.append(" context varchar(100) NOT NULL,");
		sql.append(" nesting varchar(200) NOT NULL,");
		sql.append(" name varchar(100) NOT NULL,");
		sql.append(" creation datetime NULL,");
		sql.append(" modifier int(10) UNSIGNED NULL,");
		sql.append(" modify datetime NULL,");
		sql.append(" size int(10) UNSIGNED NULL,");
		sql.append(" storage_local tinyint(1) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" storage_s3 tinyint(1) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" storage_cache  tinyint(1) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" timeout_local int(10) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" timeout_s3 int(10) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" timeout_cache int(10) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" s3_bucket int(10) UNSIGNED NULL,");
		sql.append(" s3_grant varchar(20) NULL,");
		sql.append(" s3_etag varchar(100) NULL,");
		sql.append(" s3_versionid varchar(100) NULL,");
		sql.append(" draft tinyint(1) UNSIGNED NOT NULL DEFAULT 0,");
		sql.append(" locker int(10) UNSIGNED NULL,");
		sql.append(" locking datetime NULL,");
		sql.append(" s3_status int(6) NOT NULL DEFAULT 0,");
		sql.append(" s3_status_message varchar(100) NULL,");
		sql.append(" timerecord timestamp,");
		sql.append(" primary key (uid)");
		sql.append(" ) ENGINE = MyISAM");
		sql.append(" COMMENT = 'Virtual File Allocation Table, file deleted'");
		return sql.toString();
	}


	@Override
	public String getTableName() {
		return NAME;
	}

	
	

}
