package it.softecspa.s4fs.vfat;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatementUnplugged;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Gestore anaagrafica degli Owner
 * 
 * @author m.veroni
 *
 */
public class Owner extends Autocreate {

	public static final String NAME = "s4_001_owner";
	
	private Integer uid;
	private String uname;
	
	
	private Owner() {
		super();
	}
	
	public Owner(ConnectionManager cm, String name) throws SQLException {
		this();
		selectByName(cm, name);		
	}
	
	
	
	private synchronized void selectByName(ConnectionManager cm, String uname) throws SQLException {
		DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm);
		
		try {
			StringBuilder sql = new StringBuilder(50);
			sql.append("SELECT uid, uname");
			sql.append(" FROM ").append(NAME);
			sql.append(" WHERE uname = '").append(uname).append("'");
			try {
				ResultSet res = dbsu.getResultSet(sql.toString());
				if (res.next()) {
					readRow(res);
				}			
			} catch (SQLException e1) {
				checkAndCreate(dbsu, e1);
			}
	
			
			if (uid==null) {
				uid = (int)(Math.random()*100000);
				
				// Inserisco il nuovo record
				sql = new StringBuilder(50);
				sql.append("INSERT INTO ").append(NAME).append(" (uid, uname)");
				sql.append(" VALUES (").append(uid).append(", '").append(uname).append("')");
				dbsu.execute(sql.toString());
			}
			log.info("Owner '"+uname+"' registered with uid #"+uid);
			
		} finally {				
			dbsu.free();
		}
	}
	
	
	
	
	
	
	private void readRow(ResultSet res) throws SQLException {
		this.uid = res.getInt("uid");
		this.uname = res.getString("uname");
	}

	public String getUname() {
		return uname;
	}

	public void setUname(String uname) {
		this.uname = uname;
	}

	public Integer getUid() {
		return uid;
	}
	
	
	@Override
	String createSQL() {
		StringBuilder sql = new StringBuilder(200);
		sql.append("CREATE TABLE ").append(NAME).append(" (");
		sql.append(" uid int(10) UNSIGNED NOT NULL,");
 		sql.append(" uname varchar(250) NOT NULL,");
 		sql.append(" timerecord timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,");
 		sql.append(" primary key (uid), ");
 		sql.append(" unique index iu_owner_uname (uname)");
 		sql.append(" ) ENGINE = MyISAM");
 		sql.append(" COMMENT = 'Owner virtual FAT'");	
		return sql.toString();
	}


	@Override
	public String getTableName() {
		return NAME;
	}
	
	
}
