package it.softecspa.s4fs.vfat;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.s4fs.S4Config;
import it.softecspa.s4fs.S4Engine;

import org.apache.log4j.Logger;

public class VFATStatistics {

	private String context;
	
	
	private int record;
	
	private int draft;
	private int locked;
	private int garbage;
	
	private int s3shared;
	

	VFATStatistics(String context) {
		this.context = context;
	}
	
	
	public int getRecord() {
		return record;
	}

	public void setRecord(int record) {
		this.record = record;
	}

	public int getDraft() {
		return draft;
	}

	public void setDraft(int draft) {
		this.draft = draft;
	}

	public int getLocked() {
		return locked;
	}

	public void setLocked(int locked) {
		this.locked = locked;
	}

	public int getGarbage() {
		return garbage;
	}

	public void setGarbage(int garbage) {
		this.garbage = garbage;
	}

	public int getS3shared() {
		return s3shared;
	}

	public void setS3shared(int s3shared) {
		this.s3shared = s3shared;
	}


	public String getContext() {
		return context;
	}


	public void toLog() {
		toLog(null);
	}
	
	public void toLog(Logger log) {
		if (log==null) log = Logger.getLogger(getClass());
		
		S4Engine engine = S4Engine.getInstance();
		S4Config config = engine.getConfig();
		
		
		log.info(S4Engine.class.getSimpleName() + " statistics for context '"+context+"': \n" +
				"* ---------------------------------------------------------------------- *\n" +
				"  Filesystem root: \t"+config.getFilesystemRoot() + "\n" +				
				"  Owner name:      \t"+config.getOwnerName() + "\n" +
				"  Amazon S3:       \t"+(engine.useS3Service()?"enabled":"disabled") + "\n" +
				"  Amazon S3 bucket:\t"+config.getBucketName() + "\n" +
				"  Cleaner delay:   \t"+config.getCleanerDelay() + " seconds\n" +
				"  Virtual Allocation Table\n" +
				"\t- Record:   \t"+XString.fillerSpaceLeft(""+record,5) + "\n" +
				"\t--> Draft:  \t"+XString.fillerSpaceLeft(""+draft,5) + "\n" +
				"\t--> Locked: \t"+XString.fillerSpaceLeft(""+locked,5) + "\n" +
				"\t--> Shared: \t"+XString.fillerSpaceLeft(""+s3shared,5) + "\n" +
				"\t- Garbage:  \t"+XString.fillerSpaceLeft(""+garbage,5) + "\n" +
				"* ---------------------------------------------------------------------- *");
	}
	
	
	
}
